/*
Based on the stomp_tremolo.pde from openmusiclabs.com
this program does a tremolo effect.  it uses a sinewave stored
in program memory to modulate the signal.  the rate at which
it goes through the sinewave is set by the push buttons,
which is min/maxed by the speed value.
*/

//defining harware resources.
#define LED 13
#define FOOTSWITCH 12
#define TOGGLE 2
#define PUSHBUTTON_1 A5
#define PUSHBUTTON_2 A4

//defining the output PWM parameters
#define PWM_FREQ 0x00FF // pwm frequency - 31.3KHz
#define PWM_MODE 0 // Fast (1) or Phase Correct (0)
#define PWM_QTY 2 // 2 PWMs in parallel

const char * const sinewave[] PROGMEM = {
  // this file is stored in StompShield and is a 1024 value
  // sinewave lookup table of signed 16bit integers
  // you can replace it with your own waveform if you like
  
  #include "mult16x16.h"
  #include "sinetable.inc"
  
};
unsigned int location = 0; // incoming data buffer pointer

unsigned int fractional = 0x00; // fractional sample position
int data_buffer; // temporary data storage to give a 1 sample buffer
int input, speed=20;
int counter=0;

void setup() {
//setup IO
  pinMode(FOOTSWITCH, INPUT_PULLUP);
  pinMode(TOGGLE, INPUT_PULLUP);
  pinMode(PUSHBUTTON_1, INPUT_PULLUP);
  pinMode(PUSHBUTTON_2, INPUT_PULLUP);
  pinMode(LED, OUTPUT);
  
  // setup ADC
  ADMUX = 0x60; // left adjust, adc0, internal vcc
  ADCSRA = 0xe5; // turn on adc, ck/32, auto trigger
  ADCSRB = 0x07; // t1 capture for trigger
  DIDR0 = 0x01; // turn off digital inputs for adc0

  // setup PWM
  TCCR1A = (((PWM_QTY - 1) << 5) | 0x80 | (PWM_MODE << 1)); //
  TCCR1B = ((PWM_MODE << 3) | 0x11); // ck/1
  TIMSK1 = 0x20; // interrupt on capture interrupt
  ICR1H = (PWM_FREQ >> 8);
  ICR1L = (PWM_FREQ & 0xff);
  DDRB |= ((PWM_QTY << 1) | 0x02); // turn on outputs
  sei(); // turn on interrupts - not really necessary with arduino
}

void loop() 
{
  //Turn on the LED if the effect is ON.
  if (digitalRead(FOOTSWITCH)) digitalWrite(LED, HIGH); 
    else  digitalWrite(LED, LOW);
  
  //nothing else here, all happens in the Timer 1 interruption.
}
ISR(TIMER1_CAPT_vect) { // all processing happens here

  // output the last value calculated
  OCR1AL = ((data_buffer + 0x8000) >> 8); // convert to unsigned, send out high byte
  OCR1BL = data_buffer; // send out low byte
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
//BUTTONS
  counter++; //to save resources, the pushbuttons are checked every 1000 times.
  if(counter==1000)
{ 

counter=0;
if (!digitalRead(PUSHBUTTON_2)) {
  if (speed<1024)speed=speed+1; //increase speed
    digitalWrite(LED, LOW); //blinks the led
    }

    if (!digitalRead(PUSHBUTTON_1)) {
  if (speed>0)speed=speed-1; //decrease speed
  digitalWrite(LED, LOW); //blinks the led
    }
}
    
  
  fractional += speed; // increment sinewave lookup counter
  if (fractional >= 0x0100) { // if its large enough to go to next sample
    fractional &= 0x00ff; // round off
    location += 1; // go to next location
    location &= 0x03ff; // fast boundary wrap for 2^n boundaries
  }
  // fetch current sinewave value
  int amplitude = pgm_read_word_near(sinewave + location);
  amplitude += 0x8000; // convert to unsigned
  int output;
  MultiSU16X16toH16(output, input, amplitude);
  // save value for playback next interrupt
  data_buffer = output; 
}
