/*
Octavedown for pedal shield adapted from Stompshield
Based on https://github.com/spamatica/arduino_stomp_shield_effects
*/

//defining harware resources.
#define LED 13
#define FOOTSWITCH 12
#define TOGGLE 2
#define PUSHBUTTON_1 A5
#define PUSHBUTTON_2 A4

//defining the output PWM parameters
#define PWM_FREQ 0x00FF // pwm frequency - 31.3KHz
#define PWM_MODE 0 // Fast (1) or Phase Correct (0)
#define PWM_QTY 2 // 2 PWMs in parallel


//#define B_MAX 100 // max value for rotary encoder input (min freq)
//#define B_MIN 1 // min value for rotary encoder input (max freq)

#define MIN_OUT -16383
#define MAX_OUT 16383

#define UP 0
#define DOWN 1
#define NO 0
#define YES 10

//byte button; // button checking timer
//byte last_state; // last rotary encoder state
byte counter = 10; // and start value


byte looper=0;

int oldInput;
int inMaxVal = 0;
int currDirection = UP;
int passedFirst = NO;
int l1=0;
int l2=0;

int input=0; // new input value
int output=0; // calculated current output
int oldOutput=0; // last output value
int filtered=0; // current filtered value;
int oldFiltered=0; // previousFiltered;

int average;
int outGate = 0;
int counter2=0;

void setup() {
//setup IO
  pinMode(FOOTSWITCH, INPUT_PULLUP);
  pinMode(TOGGLE, INPUT_PULLUP);
  pinMode(PUSHBUTTON_1, INPUT_PULLUP);
  pinMode(PUSHBUTTON_2, INPUT_PULLUP);
  pinMode(LED, OUTPUT);
  
  // setup ADC
  ADMUX = 0x60; // left adjust, adc0, internal vcc
  ADCSRA = 0xe5; // turn on adc, ck/32, auto trigger
  ADCSRB = 0x07; // t1 capture for trigger
  DIDR0 = 0x01; // turn off digital inputs for adc0

  // setup PWM
  TCCR1A = (((PWM_QTY - 1) << 5) | 0x80 | (PWM_MODE << 1)); //
  TCCR1B = ((PWM_MODE << 3) | 0x11); // ck/1
  TIMSK1 = 0x20; // interrupt on capture interrupt
  ICR1H = (PWM_FREQ >> 8);
  ICR1L = (PWM_FREQ & 0xff);
  DDRB |= ((PWM_QTY << 1) | 0x02); // turn on outputs
  sei(); // turn on interrupts - not really necessary with arduino
}
void loop() {
  delay(200);
}

//sounds better if left untouched
/*void checkButton()
{
//BUTTONS
  counter2++; //the pushbuttons are checked every 5000 times.
if(counter2==5000)
 
counter2=0;
  if (!digitalRead(PUSHBUTTON_1)) {
     if (counter > MIN_OUT) counter=counter-1; // if not at min, decrement
      }
      if (!digitalRead(PUSHBUTTON_2)) {
        if (counter < MAX_OUT) counter=counter+1; // if not at max, increment
      }
    }
*/

void highPassFilter() // frequency unknown ;)
{
  int filterTemp = oldFiltered + output - oldOutput;
    filtered = output - (filterTemp/(2));

//        filteredArray[i] = alpha * (filteredArray[i-1] + data.recordedSamples[i] - data.recordedSamples[i-1]);
}

ISR(TIMER1_CAPT_vect)
{
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
//  checkButton();
    
  if (input > inMaxVal)
    inMaxVal+=10;
  if (looper++ % 10 && input > 0 && input < inMaxVal)
    inMaxVal-=10;
  
  if (input < 0) // going \ past zero crossing
    if (oldInput >= 0)
      currDirection = currDirection ^ 1;

  // produce output data based on currDirection
  if (currDirection)
    output+=(counter<<5);
  else
    output-=(counter<<5);

  //calculate gate according to current input
  // if (outGate > maxVal) outGate = outGate -10;
  // if (outGate < minVal) outGate = outGate +10;

  if (inMaxVal < 1200) {
    outGate-=50;
    if (outGate < 0) outGate=0;
  }
  else 
    outGate = MAX_OUT;
  
  // limit outvalue according to current gate  
  if (output < -outGate) output=-outGate;
  if (output > outGate) output=outGate;

  highPassFilter();
  //filtered=output;

  // save data
  oldInput = input;
  oldOutput = output;
  oldFiltered = filtered;
  
  // output data
  OCR1AL = ((filtered >> 8) + 0x80); 
  OCR1BL = filtered; // output the bottom byte


}
