/*
Based on the 'stomp_updown" from openmusiclabs.com
this program plays through a sample buffer, first forward at
double rate, and then backwards at single rate.  it changes
direction at the buffer boundary. 
*/

//defining harware resources.
#define LED 13
#define FOOTSWITCH 12
#define TOGGLE 2
#define PUSHBUTTON_1 A5
#define PUSHBUTTON_2 A4

//defining the output PWM parameters
#define PWM_FREQ 0x00FF // pwm frequency - 31.3KHz
#define PWM_MODE 0 // Fast (1) or Phase Correct (0)
#define PWM_QTY 2 // 2 PWMs in parallel


#define SIZE 1000 // buffer size, make lower if it clicks
int buffer[SIZE]; // data buffer

unsigned int location = 0; // current buffer location
unsigned int offset = 0; // distance to current location
byte dir = 0; // direction of travel in buffer
int data_buffer = 0x8000;

void setup() {
//setup IO
  pinMode(FOOTSWITCH, INPUT_PULLUP);
  pinMode(TOGGLE, INPUT_PULLUP);
  pinMode(PUSHBUTTON_1, INPUT_PULLUP);
  pinMode(PUSHBUTTON_2, INPUT_PULLUP);
  pinMode(LED, OUTPUT);
  
  // setup ADC
  ADMUX = 0x60; // left adjust, adc0, internal vcc
  ADCSRA = 0xe5; // turn on adc, ck/32, auto trigger
  ADCSRB = 0x07; // t1 capture for trigger
  DIDR0 = 0x01; // turn off digital inputs for adc0

  // setup PWM
  TCCR1A = (((PWM_QTY - 1) << 5) | 0x80 | (PWM_MODE << 1)); //
  TCCR1B = ((PWM_MODE << 3) | 0x11); // ck/1
  TIMSK1 = 0x20; // interrupt on capture interrupt
  ICR1H = (PWM_FREQ >> 8);
  ICR1L = (PWM_FREQ & 0xff);
  DDRB |= ((PWM_QTY << 1) | 0x02); // turn on outputs
  sei(); // turn on interrupts - not really necessary with arduino
}

void loop() {
}

ISR(TIMER1_CAPT_vect) { // all processing happens here

  // output the last value calculated
  OCR1AL = ((data_buffer + 0x8000) >> 8); // convert to unsigned, send out high byte
  OCR1BL = data_buffer; // send out low byte
  
  // get ADC data
  byte temp1 = ADCL; // you need to fetch the low byte first
  byte temp2 = ADCH; // yes it needs to be done this way
  int input = ((temp2 << 8) | temp1) + 0x8000; // make a signed 16b value
  
  buffer[location] = input; // store current sample
  location++; // go to next location
  if (location >= SIZE) location = 0; // deal with boundary
  unsigned int temp = location + offset; // find playback location
  if (temp >= SIZE) temp -= SIZE; // boundary wrap
  data_buffer = buffer[temp]; // fetch sample
  if (dir) { // increment until at buffer boundary
    if (offset >= (SIZE - 4)) {
      dir = 0;
      offset--;
    }
    else offset++;
  }
  else { // decrement till reaching boundary from other side
   if (offset <= 4) {
     dir = 1;
     offset--;
   }
   else offset -= 2;
  }
}
